/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.common;

import com.unascribed.ears.Identified;
import com.unascribed.ears.api.EarsFeatureType;
import com.unascribed.ears.api.EarsStateType;
import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.api.registry.EarsInhibitorRegistry;
import com.unascribed.ears.api.registry.EarsStateOverriderRegistry;
import com.unascribed.ears.common.debug.DebuggingDelegate;
import com.unascribed.ears.common.debug.EarsLog;
import com.unascribed.ears.common.render.EarsRenderDelegate;
import com.unascribed.ears.common.render.IndirectEarsRenderDelegate;

class EarsRenderer {
    EarsRenderer() {
    }

    public static void render(EarsFeatures features, EarsRenderDelegate delegate) {
        EarsLog.debug(EarsLog.Tag.COMMON_RENDERER, "render({}, {})", (Object)features, (Object)delegate);
        boolean slim = delegate.isSlim();
        if (EarsLog.DEBUG && EarsLog.shouldLog(EarsLog.Tag.PLATFORM_RENDERER_DELEGATE)) {
            delegate = new DebuggingDelegate(delegate);
        }
        if (EarsLog.DEBUG && EarsLog.shouldLog(EarsLog.Tag.COMMON_RENDERER_DOTS)) {
            for (EarsRenderDelegate.BodyPart part : EarsRenderDelegate.BodyPart.values()) {
                delegate.push();
                delegate.anchorTo(part);
                delegate.renderDebugDot(1.0f, 1.0f, 1.0f, 1.0f);
                delegate.push();
                delegate.translate(part.getXSize(slim), 0.0f, 0.0f);
                delegate.renderDebugDot(1.0f, 0.0f, 0.0f, 1.0f);
                delegate.pop();
                delegate.push();
                delegate.translate(0.0f, -part.getYSize(slim), 0.0f);
                delegate.renderDebugDot(0.0f, 1.0f, 0.0f, 1.0f);
                delegate.pop();
                delegate.push();
                delegate.translate(0.0f, 0.0f, part.getZSize(slim));
                delegate.renderDebugDot(0.0f, 0.0f, 1.0f, 1.0f);
                delegate.pop();
                delegate.pop();
            }
        }
        if (features != null && features.enabled || delegate.needsSecondaryLayersDrawn()) {
            delegate.setUp();
            for (int p = 0; p < 4; ++p) {
                EarsRenderer.renderInner(features, delegate, p, false);
                if (features == null || !features.emissive || p >= 2) continue;
                delegate.setEmissive(true);
                EarsRenderer.renderInner(features, delegate, p, true);
                delegate.setEmissive(false);
            }
            delegate.bind(EarsRenderDelegate.TexSource.SKIN);
            delegate.tearDown();
        }
    }

    private static void renderInner(EarsFeatures features, EarsRenderDelegate delegate, int p, boolean drawingEmissive) {
        boolean slim = delegate.isSlim();
        float swingAmount = delegate.getLimbSwing();
        delegate.bind(drawingEmissive ? EarsRenderDelegate.TexSource.EMISSIVE_SKIN : EarsRenderDelegate.TexSource.SKIN);
        if (drawingEmissive) {
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
            EarsRenderer.drawVanillaCuboid(delegate, 0, 0, 8, 8, 8, 0.0f);
            delegate.pop();
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.TORSO);
            EarsRenderer.drawVanillaCuboid(delegate, 16, 16, 8, 12, 4, 0.0f);
            delegate.pop();
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.LEFT_ARM);
            EarsRenderer.drawVanillaCuboid(delegate, 32, 48, slim ? 3 : 4, 12, 4, 0.0f);
            delegate.pop();
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.RIGHT_ARM);
            EarsRenderer.drawVanillaCuboid(delegate, 40, 16, slim ? 3 : 4, 12, 4, 0.0f);
            delegate.pop();
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.LEFT_LEG);
            EarsRenderer.drawVanillaCuboid(delegate, 16, 48, 4, 12, 4, 0.0f);
            delegate.pop();
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.RIGHT_LEG);
            EarsRenderer.drawVanillaCuboid(delegate, 0, 16, 4, 12, 4, 0.0f);
            delegate.pop();
        }
        if (delegate.needsSecondaryLayersDrawn() || drawingEmissive) {
            if (drawingEmissive) {
                delegate.push();
                delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                delegate.translate(0.0f, 1.0f, 0.0f);
                EarsRenderer.drawVanillaCuboid(delegate, 32, 0, 8, 8, 8, 0.5f);
                delegate.pop();
            }
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.TORSO);
            delegate.translate(0.0f, 0.5f, 0.0f);
            EarsRenderer.drawVanillaCuboid(delegate, 16, 32, 8, 12, 4, 0.25f);
            delegate.pop();
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.LEFT_ARM);
            delegate.translate(0.0f, 0.5f, 0.0f);
            EarsRenderer.drawVanillaCuboid(delegate, 48, 48, slim ? 3 : 4, 12, 4, 0.25f);
            delegate.pop();
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.RIGHT_ARM);
            delegate.translate(0.0f, 0.5f, 0.0f);
            EarsRenderer.drawVanillaCuboid(delegate, 40, 32, slim ? 3 : 4, 12, 4, 0.25f);
            delegate.pop();
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.LEFT_LEG);
            delegate.translate(0.0f, 0.5f, 0.0f);
            EarsRenderer.drawVanillaCuboid(delegate, 0, 48, 4, 12, 4, 0.25f);
            delegate.pop();
            delegate.push();
            delegate.anchorTo(EarsRenderDelegate.BodyPart.RIGHT_LEG);
            delegate.translate(0.0f, 0.5f, 0.0f);
            EarsRenderer.drawVanillaCuboid(delegate, 0, 32, 4, 12, 4, 0.25f);
            delegate.pop();
        }
        if (features != null && features.enabled) {
            EarsFeatures.WingMode wingMode;
            float chestSize;
            double yawZ;
            if (p == 1 && delegate instanceof IndirectEarsRenderDelegate) {
                ((IndirectEarsRenderDelegate)delegate).beginTranslucent();
            }
            delegate.bind(drawingEmissive ? EarsRenderDelegate.TexSource.EMISSIVE_SKIN : EarsRenderDelegate.TexSource.SKIN);
            if (p == 0) {
                EarsFeatures.EarMode earMode = features.earMode;
                EarsFeatures.EarAnchor earAnchor = features.earAnchor;
                if (earMode != EarsFeatures.EarMode.NONE && EarsRenderer.isInhibited(delegate, EarsFeatureType.EARS)) {
                    earMode = EarsFeatures.EarMode.NONE;
                }
                if (earMode == EarsFeatures.EarMode.ABOVE || earMode == EarsFeatures.EarMode.AROUND) {
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    if (earAnchor == EarsFeatures.EarAnchor.CENTER) {
                        delegate.translate(0.0f, 0.0f, 4.0f);
                    } else if (earAnchor == EarsFeatures.EarAnchor.BACK) {
                        delegate.translate(0.0f, 0.0f, 8.0f);
                    }
                    delegate.push();
                    delegate.translate(-4.0f, -16.0f, 0.0f);
                    delegate.renderFront(24, 0, 16, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 28, 16, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                    if (earMode == EarsFeatures.EarMode.AROUND) {
                        delegate.translate(-4.0f, -8.0f, 0.0f);
                        delegate.renderFront(36, 16, 4, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                        delegate.renderBack(12, 16, 4, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                        delegate.translate(12.0f, 0.0f, 0.0f);
                        delegate.renderFront(36, 32, 4, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                        delegate.renderBack(12, 32, 4, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    }
                    delegate.pop();
                } else if (earMode == EarsFeatures.EarMode.SIDES) {
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    if (earAnchor == EarsFeatures.EarAnchor.CENTER) {
                        delegate.translate(0.0f, 0.0f, 4.0f);
                    } else if (earAnchor == EarsFeatures.EarAnchor.BACK) {
                        delegate.translate(0.0f, 0.0f, 8.0f);
                    }
                    delegate.translate(-8.0f, -8.0f, 0.0f);
                    delegate.renderFront(24, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 28, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.translate(16.0f, 0.0f, 0.0f);
                    delegate.renderFront(32, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 36, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                } else if (earMode == EarsFeatures.EarMode.BEHIND) {
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                    delegate.translate(-16.0f, -8.0f, 0.0f);
                    delegate.renderFront(24, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 28, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                    delegate.translate(-8.0f, 0.0f, -8.0f);
                    delegate.renderFront(32, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 36, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                } else if (earMode == EarsFeatures.EarMode.FLOPPY) {
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                    delegate.translate(-8.0f, -7.0f, 0.0f);
                    delegate.rotate(-30.0f, 1.0f, 0.0f, 0.0f);
                    delegate.translate(0.0f, 0.0f, 0.0f);
                    delegate.renderFront(24, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 28, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    delegate.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
                    delegate.translate(0.0f, -7.0f, -8.0f);
                    delegate.rotate(-30.0f, 1.0f, 0.0f, 0.0f);
                    delegate.translate(0.0f, 0.0f, 0.0f);
                    delegate.renderFront(32, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 36, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                } else if (earMode == EarsFeatures.EarMode.CROSS) {
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    if (earAnchor == EarsFeatures.EarAnchor.CENTER) {
                        delegate.translate(0.0f, 0.0f, 4.0f);
                    } else if (earAnchor == EarsFeatures.EarAnchor.BACK) {
                        delegate.translate(0.0f, 0.0f, 8.0f);
                    }
                    delegate.translate(4.0f, -16.0f, 0.0f);
                    delegate.push();
                    delegate.rotate(45.0f, 0.0f, 1.0f, 0.0f);
                    delegate.translate(-4.0f, 0.0f, 0.0f);
                    delegate.renderFront(24, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 28, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                    delegate.push();
                    delegate.rotate(-45.0f, 0.0f, 1.0f, 0.0f);
                    delegate.translate(-4.0f, 0.0f, 0.0f);
                    delegate.renderFront(32, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 36, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                    delegate.pop();
                } else if (earMode == EarsFeatures.EarMode.OUT) {
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                    if (earAnchor == EarsFeatures.EarAnchor.BACK) {
                        delegate.translate(-16.0f, -8.0f, 0.0f);
                    } else if (earAnchor == EarsFeatures.EarAnchor.CENTER) {
                        delegate.translate(-8.0f, -16.0f, 0.0f);
                    } else if (earAnchor == EarsFeatures.EarAnchor.FRONT) {
                        delegate.translate(0.0f, -8.0f, 0.0f);
                    }
                    delegate.renderFront(24, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 28, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                    delegate.translate(-8.0f, 0.0f, -8.0f);
                    delegate.renderFront(32, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 36, 8, 8, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                } else if (earMode == EarsFeatures.EarMode.TALL) {
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    delegate.translate(0.0f, -8.0f, 0.0f);
                    if (earAnchor == EarsFeatures.EarAnchor.CENTER) {
                        delegate.translate(0.0f, 0.0f, 4.0f);
                    } else if (earAnchor == EarsFeatures.EarAnchor.BACK) {
                        delegate.translate(0.0f, 0.0f, 8.0f);
                    }
                    float ang = -6.0f;
                    double dX = delegate.getCapeX() - delegate.getX();
                    double dZ = delegate.getCapeZ() - delegate.getZ();
                    float yaw = delegate.getBodyYaw();
                    double yawX = Math.sin(Math.toRadians(yaw));
                    yawZ = -Math.cos(Math.toRadians(yaw));
                    float dForward = (float)(dX * yawX + dZ * yawZ) * 25.0f;
                    if (dForward > 80.0f) {
                        dForward = 80.0f;
                    }
                    if (dForward < -80.0f) {
                        dForward = -80.0f;
                    }
                    delegate.rotate((ang -= dForward) / 3.0f, 1.0f, 0.0f, 0.0f);
                    delegate.translate(0.0f, -4.0f, 0.0f);
                    delegate.renderFront(24, 0, 8, 4, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 40, 8, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.rotate(ang, 1.0f, 0.0f, 0.0f);
                    delegate.translate(0.0f, -4.0f, 0.0f);
                    delegate.renderFront(28, 0, 8, 4, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 36, 8, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.rotate(ang / 2.0f, 1.0f, 0.0f, 0.0f);
                    delegate.translate(0.0f, -4.0f, 0.0f);
                    delegate.renderFront(32, 0, 8, 4, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 32, 8, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.rotate(ang, 1.0f, 0.0f, 0.0f);
                    delegate.translate(0.0f, -4.0f, 0.0f);
                    delegate.renderFront(36, 0, 8, 4, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 28, 8, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                } else if (earMode == EarsFeatures.EarMode.TALL_CROSS) {
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    if (earAnchor == EarsFeatures.EarAnchor.CENTER) {
                        delegate.translate(0.0f, 0.0f, 4.0f);
                    } else if (earAnchor == EarsFeatures.EarAnchor.BACK) {
                        delegate.translate(0.0f, 0.0f, 8.0f);
                    }
                    delegate.translate(4.0f, -24.0f, 0.0f);
                    delegate.push();
                    delegate.rotate(45.0f, 0.0f, 1.0f, 0.0f);
                    delegate.translate(-4.0f, 0.0f, 0.0f);
                    delegate.renderFront(24, 0, 8, 16, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 28, 8, 16, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                    delegate.push();
                    delegate.rotate(-45.0f, 0.0f, 1.0f, 0.0f);
                    delegate.translate(-4.0f, 0.0f, 0.0f);
                    delegate.renderFront(24, 0, 8, 16, EarsRenderDelegate.TexRotation.CW, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.renderBack(56, 28, 8, 16, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                    delegate.pop();
                }
                EarsFeatures.TailMode tailMode = features.tailMode;
                if (tailMode != EarsFeatures.TailMode.NONE && !EarsRenderer.isInhibited(delegate, EarsFeatureType.TAIL)) {
                    int segments;
                    boolean vert;
                    float ang = 0.0f;
                    float swing = 0.0f;
                    if (tailMode == EarsFeatures.TailMode.DOWN) {
                        ang = 30.0f;
                        swing = 40.0f;
                    } else if (tailMode == EarsFeatures.TailMode.BACK) {
                        ang = features.tailBend0 != 0.0f ? 90.0f : 80.0f;
                        swing = 20.0f;
                    } else if (tailMode == EarsFeatures.TailMode.UP) {
                        ang = 130.0f;
                        swing = -20.0f;
                    }
                    float baseAngle = features.tailBend0;
                    if (EarsRenderer.isActive(delegate, EarsStateType.GLIDING)) {
                        baseAngle = -30.0f;
                        ang = 0.0f;
                    }
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.TORSO);
                    delegate.translate(0.0f, -2.0f, 4.0f);
                    delegate.rotate(ang + swingAmount * swing + (float)(Math.sin(delegate.getTime() / 12.0f) * 4.0), 1.0f, 0.0f, 0.0f);
                    boolean bl = vert = tailMode == EarsFeatures.TailMode.VERTICAL;
                    if (vert) {
                        delegate.translate(4.0f, 0.0f, 0.0f);
                        delegate.rotate(90.0f, 0.0f, 0.0f, 1.0f);
                        if (baseAngle < 0.0f) {
                            delegate.translate(4.0f, 0.0f, 0.0f);
                            delegate.rotate(baseAngle, 0.0f, 1.0f, 0.0f);
                            delegate.translate(-4.0f, 0.0f, 0.0f);
                        }
                        delegate.translate(-4.0f, 0.0f, 0.0f);
                        if (baseAngle > 0.0f) {
                            delegate.rotate(baseAngle, 0.0f, 1.0f, 0.0f);
                        }
                        delegate.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if ((segments = features.tailSegments) <= 0) {
                        segments = 1;
                    }
                    float[] angles = new float[]{vert ? 0.0f : baseAngle, features.tailBend1, features.tailBend2, features.tailBend3};
                    int segHeight = 12 / segments;
                    for (int i = 0; i < segments; ++i) {
                        delegate.rotate(angles[i] * (1.0f - swingAmount / 2.0f), 1.0f, 0.0f, 0.0f);
                        delegate.renderDoubleSided(56, 16 + i * segHeight, 8, segHeight, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.NONE);
                        delegate.translate(0.0f, segHeight, 0.0f);
                    }
                    delegate.pop();
                }
                boolean claws = features.claws;
                boolean horn = features.horn;
                if (claws) {
                    if (!EarsRenderer.isActive(delegate, EarsStateType.WEARING_BOOTS)) {
                        if (!EarsRenderer.isInhibited(delegate, EarsFeatureType.CLAW_LEFT_LEG)) {
                            delegate.push();
                            delegate.anchorTo(EarsRenderDelegate.BodyPart.LEFT_LEG);
                            delegate.translate(0.0f, 0.0f, -4.0f);
                            delegate.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                            delegate.renderDoubleSided(16, 48, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.NONE);
                            delegate.pop();
                        }
                        if (!EarsRenderer.isInhibited(delegate, EarsFeatureType.CLAW_RIGHT_LEG)) {
                            delegate.push();
                            delegate.anchorTo(EarsRenderDelegate.BodyPart.RIGHT_LEG);
                            delegate.translate(0.0f, 0.0f, -4.0f);
                            delegate.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                            delegate.renderDoubleSided(0, 16, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.NONE);
                            delegate.pop();
                        }
                    }
                    if (!EarsRenderer.isInhibited(delegate, EarsFeatureType.CLAW_LEFT_ARM)) {
                        delegate.push();
                        delegate.anchorTo(EarsRenderDelegate.BodyPart.LEFT_ARM);
                        delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                        delegate.translate(-4.0f, 0.0f, slim ? 3.0f : 4.0f);
                        delegate.renderDoubleSided(44, 48, 4, 4, EarsRenderDelegate.TexRotation.UPSIDE_DOWN, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.NONE);
                        delegate.pop();
                    }
                    if (!EarsRenderer.isInhibited(delegate, EarsFeatureType.CLAW_RIGHT_ARM)) {
                        delegate.push();
                        delegate.anchorTo(EarsRenderDelegate.BodyPart.RIGHT_ARM);
                        delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                        delegate.translate(-4.0f, 0.0f, 0.0f);
                        delegate.renderDoubleSided(52, 16, 4, 4, EarsRenderDelegate.TexRotation.UPSIDE_DOWN, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                        delegate.pop();
                    }
                }
                if (horn && !EarsRenderer.isInhibited(delegate, EarsFeatureType.HORN)) {
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    delegate.translate(0.0f, -8.0f, 0.0f);
                    delegate.rotate(25.0f, 1.0f, 0.0f, 0.0f);
                    delegate.translate(0.0f, -8.0f, 0.0f);
                    delegate.renderDoubleSided(56, 0, 8, 8, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                }
                int snoutOffset = features.snoutOffset;
                int snoutWidth = features.snoutWidth;
                int snoutHeight = features.snoutHeight;
                int snoutDepth = features.snoutDepth;
                if (snoutWidth > 0 && snoutHeight > 0 && snoutDepth > 0 && !EarsRenderer.isInhibited(delegate, EarsFeatureType.SNOUT)) {
                    int i;
                    delegate.push();
                    delegate.anchorTo(EarsRenderDelegate.BodyPart.HEAD);
                    delegate.translate((float)(8 - snoutWidth) / 2.0f, -(snoutOffset + snoutHeight), -snoutDepth);
                    delegate.renderDoubleSided(0, 2, snoutWidth, snoutHeight, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.push();
                    delegate.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
                    delegate.translate(0.0f, -1.0f, 0.0f);
                    delegate.renderDoubleSided(0, 1, snoutWidth, 1, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    for (i = 0; i < snoutDepth - 1; ++i) {
                        delegate.translate(0.0f, -1.0f, 0.0f);
                        delegate.renderDoubleSided(0, 0, snoutWidth, 1, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    }
                    delegate.pop();
                    delegate.push();
                    delegate.translate(0.0f, snoutHeight, 0.0f);
                    delegate.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                    delegate.renderDoubleSided(0, 2 + snoutHeight, snoutWidth, 1, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    for (i = 0; i < snoutDepth - 1; ++i) {
                        delegate.translate(0.0f, 1.0f, 0.0f);
                        delegate.renderDoubleSided(0, 2 + snoutHeight + 1, snoutWidth, 1, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    }
                    delegate.pop();
                    delegate.push();
                    delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                    delegate.push();
                    delegate.translate(-1.0f, 0.0f, 0.0f);
                    delegate.renderDoubleSided(7, 0, 1, snoutHeight, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    for (i = 0; i < snoutDepth - 1; ++i) {
                        delegate.translate(-1.0f, 0.0f, 0.0f);
                        delegate.renderDoubleSided(7, 4, 1, snoutHeight, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    }
                    delegate.pop();
                    delegate.push();
                    delegate.translate(-1.0f, 0.0f, snoutWidth);
                    delegate.renderDoubleSided(7, 0, 1, snoutHeight, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    for (i = 0; i < snoutDepth - 1; ++i) {
                        delegate.translate(-1.0f, 0.0f, 0.0f);
                        delegate.renderDoubleSided(7, 4, 1, snoutHeight, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    }
                    delegate.pop();
                    delegate.pop();
                    delegate.pop();
                }
            }
            if ((chestSize = features.chestSize) > 0.0f && (!EarsRenderer.isActive(delegate, EarsStateType.WEARING_CHESTPLATE) || delegate.canBind(EarsRenderDelegate.TexSource.CHESTPLATE)) && (p == 0 || p == 1 && delegate.isJacketEnabled() || (p == 2 || p == 3 && delegate.canBind(EarsRenderDelegate.TexSource.GLINT_CHESTPLATE)) && !drawingEmissive && delegate.canBind(EarsRenderDelegate.TexSource.CHESTPLATE)) && !EarsRenderer.isInhibited(delegate, EarsFeatureType.CHEST)) {
                delegate.push();
                delegate.anchorTo(EarsRenderDelegate.BodyPart.TORSO);
                delegate.translate(0.0f, -10.0f, 0.0f);
                delegate.rotate(-chestSize * 45.0f, 1.0f, 0.0f, 0.0f);
                if (p == 2) {
                    delegate.bind(EarsRenderDelegate.TexSource.CHESTPLATE);
                } else if (p == 3) {
                    delegate.bind(EarsRenderDelegate.TexSource.GLINT_CHESTPLATE);
                }
                if (p == 0) {
                    delegate.renderDoubleSided(20, 22, 8, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                } else if (p == 1) {
                    delegate.push();
                    delegate.translate(4.0f, 2.0f, 0.0f);
                    delegate.scale(1.0625f, 1.125f, 1.0f);
                    delegate.translate(-4.0f, -2.0f, 0.0f);
                    delegate.translate(0.0f, 0.0f, -0.25f);
                    delegate.renderDoubleSided(0, 48, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.translate(4.0f, 0.0f, 0.0f);
                    delegate.renderDoubleSided(12, 48, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                } else if (p == 2 || p == 3) {
                    delegate.push();
                    delegate.translate(0.0f, 1.0f, -1.0f);
                    delegate.renderFront(20, 24, 8, 3, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.FULLPIXEL);
                    delegate.pop();
                }
                delegate.push();
                delegate.translate(0.0f, 4.0f, 0.0f);
                delegate.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                if (p == 0) {
                    delegate.renderDoubleSided(56, 44, 8, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                } else if (p == 1) {
                    delegate.push();
                    delegate.translate(0.0f, 0.0f, -0.25f);
                    delegate.renderDoubleSided(28, 48, 8, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.QUARTERPIXEL);
                    delegate.pop();
                } else if (p == 2 || p == 3) {
                    delegate.push();
                    delegate.translate(0.0f, 0.0f, -1.0f);
                    delegate.renderFront(20, 25, 8, 3, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.FULLPIXEL);
                    delegate.pop();
                }
                delegate.pop();
                delegate.push();
                delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                delegate.translate(-4.0f, 0.0f, 0.01f);
                if (p == 0) {
                    delegate.renderDoubleSided(60, 48, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                } else if (p == 1) {
                    delegate.push();
                    delegate.translate(0.0f, 0.0f, -0.25f);
                    delegate.renderDoubleSided(48, 48, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.QUARTERPIXEL);
                    delegate.pop();
                } else if (p == 2 || p == 3) {
                    delegate.push();
                    delegate.translate(0.0f, 0.0f, -1.0f);
                    delegate.renderFront(16, 20, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.FULLPIXEL);
                    delegate.pop();
                }
                delegate.translate(0.0f, 0.0f, 7.98f);
                delegate.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                delegate.translate(-4.0f, 0.0f, 0.0f);
                if (p == 0) {
                    delegate.renderDoubleSided(60, 48, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.NONE);
                } else if (p == 1) {
                    delegate.push();
                    delegate.translate(0.0f, 0.0f, -0.25f);
                    delegate.renderDoubleSided(48, 48, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.QUARTERPIXEL);
                    delegate.pop();
                } else if (p == 2 || p == 3) {
                    delegate.push();
                    delegate.translate(0.0f, 0.0f, -1.0f);
                    delegate.renderFront(16, 20, 4, 4, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.FULLPIXEL);
                    delegate.pop();
                }
                delegate.pop();
                delegate.pop();
            }
            if (p == 0 && !EarsRenderer.isInhibited(delegate, EarsFeatureType.WINGS) && (wingMode = features.wingMode) != EarsFeatures.WingMode.NONE) {
                boolean g = EarsRenderer.isActive(delegate, EarsStateType.GLIDING);
                boolean f = EarsRenderer.isActive(delegate, EarsStateType.CREATIVE_FLYING);
                delegate.push();
                float wiggle = features.animateWings ? (g ? -40.0f : (float)(Math.sin((delegate.getTime() + 8.0f) / (float)(f ? 2 : 12)) * (double)(f ? 20 : 2)) + swingAmount * 10.0f) : 0.0f;
                delegate.anchorTo(EarsRenderDelegate.BodyPart.TORSO);
                delegate.bind(drawingEmissive ? EarsRenderDelegate.TexSource.EMISSIVE_WING : EarsRenderDelegate.TexSource.WING);
                delegate.translate(2.0f, -14.0f, 4.0f);
                if (wingMode == EarsFeatures.WingMode.SYMMETRIC_DUAL || wingMode == EarsFeatures.WingMode.ASYMMETRIC_R) {
                    delegate.push();
                    delegate.rotate(-120.0f + wiggle, 0.0f, 1.0f, 0.0f);
                    delegate.renderDoubleSided(0, 0, 20, 16, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                }
                if (wingMode == EarsFeatures.WingMode.SYMMETRIC_DUAL || wingMode == EarsFeatures.WingMode.ASYMMETRIC_L) {
                    delegate.translate(4.0f, 0.0f, 0.0f);
                    delegate.push();
                    delegate.rotate(-60.0f - wiggle, 0.0f, 1.0f, 0.0f);
                    delegate.renderDoubleSided(0, 0, 20, 16, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                }
                if (wingMode == EarsFeatures.WingMode.SYMMETRIC_SINGLE) {
                    delegate.translate(2.0f, 0.0f, 0.0f);
                    delegate.push();
                    delegate.rotate(-90.0f + wiggle, 0.0f, 1.0f, 0.0f);
                    delegate.renderDoubleSided(0, 0, 20, 16, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                    delegate.pop();
                }
                delegate.pop();
            }
            if (!drawingEmissive && p == 0 && features.capeEnabled && !EarsRenderer.isInhibited(delegate, EarsFeatureType.CAPE) && !EarsRenderer.isActive(delegate, EarsStateType.WEARING_ELYTRA)) {
                delegate.push();
                delegate.anchorTo(EarsRenderDelegate.BodyPart.TORSO);
                delegate.translate(4.0f, -12.0f, 5.0f);
                double dX = delegate.getCapeX() - delegate.getX();
                double dY = delegate.getCapeY() - delegate.getY();
                double dZ = delegate.getCapeZ() - delegate.getZ();
                float yaw = delegate.getBodyYaw();
                double yawX = Math.sin(Math.toRadians(yaw));
                yawZ = -Math.cos(Math.toRadians(yaw));
                float dUp = (float)dY * 10.0f;
                dUp = EarsRenderer.clamp(dUp, -6.0f, 32.0f);
                float dForward = (float)(dX * yawX + dZ * yawZ) * 100.0f;
                dForward = EarsRenderer.clamp(dForward, 0.0f, 150.0f);
                float dSide = (float)(dX * yawZ - dZ * yawX) * 100.0f;
                dSide = EarsRenderer.clamp(dSide, -20.0f, 20.0f);
                if (dForward < 0.0f) {
                    dForward = 0.0f;
                }
                float stride = delegate.getStride();
                dUp = (float)((double)dUp + Math.sin(delegate.getHorizontalSpeed() * 6.0f) * 32.0 * (double)stride);
                delegate.rotate(6.0f + dForward / 2.0f + dUp, 1.0f, 0.0f, 0.0f);
                delegate.rotate(dSide / 2.0f, 0.0f, 0.0f, 1.0f);
                delegate.rotate(180.0f - dSide / 2.0f, 0.0f, 1.0f, 0.0f);
                delegate.bind(EarsRenderDelegate.TexSource.CAPE);
                delegate.translate(-5.0f, 0.0f, 0.0f);
                delegate.renderDoubleSided(0, 0, 10, 16, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                delegate.push();
                delegate.translate(10.0f, 0.0f, 1.0f);
                delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                delegate.renderDoubleSided(0, 0, 1, 16, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.NONE);
                delegate.translate(0.0f, 0.0f, 0.0f);
                delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                delegate.renderDoubleSided(10, 0, 10, 16, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
                delegate.translate(10.0f, 0.0f, 1.0f);
                delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                delegate.renderDoubleSided(9, 0, 1, 16, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.NONE);
                delegate.pop();
                delegate.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                delegate.renderDoubleSided(0, 0, 10, 1, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.VERTICAL, EarsRenderDelegate.QuadGrow.NONE);
                delegate.translate(0.0f, 0.0f, -16.0f);
                delegate.renderDoubleSided(10, 15, 10, 1, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.VERTICAL, EarsRenderDelegate.QuadGrow.NONE);
                delegate.bind(EarsRenderDelegate.TexSource.SKIN);
                delegate.pop();
            }
        }
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(Math.min(v, max), min);
    }

    private static void drawVanillaCuboid(EarsRenderDelegate delegate, int u, int v, int w, int h, int d, float g) {
        float g2 = g * 2.0f;
        delegate.translate((float)w / 2.0f, (float)h / 2.0f, (float)d / 2.0f);
        delegate.scale(((float)w + g2) / (float)w, ((float)h + g2) / (float)h, ((float)d + g2) / (float)d);
        delegate.translate((float)(-w) / 2.0f, (float)(-h) * 1.5f, (float)(-d) / 2.0f);
        delegate.renderDoubleSided(u + d, v + d, w, h, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
        delegate.push();
        delegate.translate(w, 0.0f, d);
        delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        delegate.renderDoubleSided(u + d + w, v + d, d, h, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.NONE);
        delegate.translate(0.0f, 0.0f, 0.0f);
        delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        delegate.renderDoubleSided(u + d + w + d, v + d, w, h, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.NONE, EarsRenderDelegate.QuadGrow.NONE);
        delegate.translate(w, 0.0f, d);
        delegate.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        delegate.renderDoubleSided(u, v + d, d, h, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.HORIZONTAL, EarsRenderDelegate.QuadGrow.NONE);
        delegate.pop();
        delegate.rotate(90.0f, 1.0f, 0.0f, 0.0f);
        delegate.renderDoubleSided(u + d, v, w, d, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.VERTICAL, EarsRenderDelegate.QuadGrow.NONE);
        delegate.translate(0.0f, 0.0f, -h);
        delegate.renderDoubleSided(u + d + w, v, w, d, EarsRenderDelegate.TexRotation.NONE, EarsRenderDelegate.TexFlip.VERTICAL, EarsRenderDelegate.QuadGrow.NONE);
    }

    private static boolean isInhibited(EarsRenderDelegate delegate, EarsFeatureType feature) {
        String namespace = EarsInhibitorRegistry.isInhibited(feature, delegate.getPeer());
        if (namespace != null) {
            EarsLog.debug(EarsLog.Tag.COMMON_API, "Rendering of feature {} is being inhibited by {}", (Object)feature, (Object)namespace);
            return true;
        }
        return false;
    }

    private static boolean isActive(EarsRenderDelegate delegate, EarsStateType state) {
        boolean def = false;
        switch (state) {
            case CREATIVE_FLYING: {
                def = delegate.isFlying();
                break;
            }
            case GLIDING: {
                def = delegate.isGliding();
                break;
            }
            case WEARING_BOOTS: {
                def = delegate.isWearingBoots();
                break;
            }
            case WEARING_CHESTPLATE: {
                def = delegate.isWearingChestplate();
                break;
            }
            case WEARING_ELYTRA: {
                def = delegate.isWearingElytra();
                break;
            }
            case WEARING_HELMET: {
                def = false;
                break;
            }
            case WEARING_LEGGINGS: {
                def = false;
                break;
            }
        }
        Identified<Boolean> id = EarsStateOverriderRegistry.isActive(state, delegate.getPeer(), def);
        if (id.getNamespace() != null) {
            EarsLog.debug(EarsLog.Tag.COMMON_API, "State of {} is being overridden to {} from {} by {}", (Object)state, id.getValue(), def, id.getNamespace());
        }
        return id.getValue();
    }
}

